# -*- coding: utf-8 -*-

from resources.lib.modules import control
from resources.lib.modules import log_utils

kodi_version = control.getKodiVersion()
if kodi_version >= 20:
    from resources.lib.modules.listitem import ListItemInfoTag


def playItem(url, title=''):
    try:
        if not title:
            title = control.infoLabel('ListItem.Title')
        item = control.item(path=url)
        item.setProperty('IsPlayable', 'true')
        if kodi_version >= 20:
            info_tag = ListItemInfoTag(item, 'video')
            info_tag.set_info({'title': title})
        else:
            item.setInfo(type='Video', infoLabels={'title': title})
        control.player.play(url, item)
    except:
        log_utils.log('playItem', 1)
        control.infoDialog('Error : No Stream Available.', sound=False, icon='INFO')
        pass
    return


def playMedia(url):
    try:
        control.execute('PlayMedia(%s)' % url)
    except:
        log_utils.log('playMedia', 1)
        control.infoDialog('Error : No Stream Available.', sound=False, icon='INFO')
        pass
    return


def play(url, title=''):
    try:
        player_choice = control.setting('player.choice') or '0'
        if player_choice == '0':
            return playItem(url, title)
        else:
            return playMedia(url)
    except:
        log_utils.log('play', 1)
        pass
    return


