# -*- coding: utf-8 -*-

import os
import six
import traceback

from io import open
from kodi_six import xbmc

from resources.lib.modules import control

LOGDEBUG = xbmc.LOGDEBUG
LOGINFO = xbmc.LOGINFO
LOGNOTICE = xbmc.LOGNOTICE if control.getKodiVersion() < 19 else xbmc.LOGINFO
LOGWARNING = xbmc.LOGWARNING
LOGERROR = xbmc.LOGERROR
LOGFATAL = xbmc.LOGFATAL
LOGNONE = xbmc.LOGNONE

version = control.addonInfo('version')

information_head = '--[ [COLOR purple]Json IPTV - %s [/COLOR]Information ]--' % version
information_file = os.path.join(control.addonPath, 'resources', 'information.txt')
changelog_head = '--[ [COLOR purple]Json IPTV - %s [/COLOR]ChangeLog ]--' % version
changelog_file = os.path.join(control.addonPath, 'resources', 'changelog.txt')

debuglog_path = control.transPath('special://logpath/')
debuglog_file = os.path.join(debuglog_path, 'json_iptv.log')
debuglog_head = '--[ [COLOR purple]Json IPTV - %s [/COLOR]DebugLog ]--' % version
debuglog_prefix = '[ [COLOR purple]Json IPTV - %s - DEBUG[/COLOR] ]' % version

debug_enabled = control.setting('addon.debug')


def log(msg, trace=0, level=LOGDEBUG):
    if not debug_enabled == 'true':
        return
    try:
        if trace == 1:
            failure = six.ensure_str(traceback.format_exc())
            _msg = '%s: %s' % (six.ensure_text(msg), failure)
        else:
            _msg = '%s' % six.ensure_text(msg)
        if not os.path.exists(debuglog_file):
            f = open(debuglog_file, 'w')
            f.close()
        with open(debuglog_file, 'a', encoding='utf-8') as f:
            line = '%s: %s' % (debuglog_prefix, _msg)
            f.write(line.rstrip('\r\n') + '\n')
    except Exception as e:
        xbmc.log('%s Logging Failure: %s' % (debuglog_prefix, e), level)
        pass


def view_information():
    try:
        control.textViewer(information_file, information_head)
    except:
        log('view_information', 1)
        control.infoDialog('Error Opening Information')
        pass


def view_changelog():
    try:
        control.textViewer(changelog_file, changelog_head)
    except:
        log('view_changelog', 1)
        control.infoDialog('Error Opening ChangeLog')
        pass


def view_debuglog():
    try:
        control.textViewer(debuglog_file, debuglog_head)
    except:
        log('view_debuglog', 1)
        control.infoDialog('Error Opening DebugLog')
        pass


def empty_debuglog():
    try:
        yes = control.yesnoDialog('Clear DebugLog?')
        if not yes:
            return
        open(debuglog_file, 'w').close()
        control.infoDialog('DebugLog Cleared.', sound=True, icon='INFO')
    except:
        log('empty_log', 1)
        control.infoDialog('Error Clearing DebugLog')
        pass


