# -*- coding: utf-8 -*-

from six import ensure_str

from resources.lib.modules import control


colorChart = ['none', 'aliceblue', 'aqua', 'aquamarine', 'azure', 'beige',
    'bisque', 'black', 'blanchedalmond', 'blue', 'blueviolet', 'brown',
    'burlywood', 'cadetblue', 'chartreuse', 'chocolate', 'coral',
    'cornflowerblue', 'cornsilk', 'crimson', 'cyan', 'darkblue', 'darkcyan',
    'darkgoldenrod', 'darkgray', 'darkgreen', 'darkkhaki', 'darkmagenta',
    'darkolivegreen', 'darkorange', 'darkorchid', 'darkred', 'darksalmon',
    'darkseagreen', 'darkslateblue', 'darkslategray', 'darkturquoise',
    'darkviolet', 'deeppink', 'deepskyblue', 'dimgray', 'dodgerblue',
    'firebrick', 'floralwhite', 'forestgreen', 'fuchsia', 'gainsboro',
    'ghostwhite', 'gold', 'goldenrod', 'gray', 'green', 'greenyellow',
    'honeydew', 'hotpink', 'indianred', 'indigo', 'ivory', 'khaki', 'kodi',
    'lavender', 'lavenderblush', 'lawngreen', 'lemonchiffon', 'lightblue',
    'lightcoral', 'lightcyan', 'lightgoldenrodyellow', 'lightgray',
    'lightgreen', 'lightpink', 'lightsalmon', 'lightseagreen', 'lightskyblue',
    'lightslategray', 'lightsteelblue', 'lightyellow', 'lime', 'limegreen',
    'linen', 'magenta', 'maroon', 'mediumaquamarine', 'mediumblue', 'mediumorchid',
    'mediumpurple', 'mediumseagreen', 'mediumslateblue', 'mediumspringgreen',
    'mediumturquoise', 'mediumvioletred', 'midnightblue', 'mintcream', 'mistyrose',
    'moccasin', 'navajowhite', 'navy', 'oldlace', 'olive', 'olivedrab', 'orange',
    'orangered', 'orchid', 'palegoldenrod', 'palegreen', 'paleturquoise', 'palevioletred',
    'papayawhip', 'peachpuff', 'peru', 'pink', 'plum', 'powderblue', 'purple', 'red',
    'rosybrown', 'royalblue', 'saddlebrown', 'salmon', 'sandybrown', 'seagreen',
    'seashell', 'sienna', 'silver', 'skyblue', 'slateblue', 'slategray', 'snow',
    'springgreen', 'steelblue', 'tan', 'teal', 'thistle', 'tomato', 'turquoise',
    'violet', 'white', 'whitesmoke', 'yellow', 'yellowgreen'
]


try:
    addon_usecolor = control.setting('addon.usecolor')
except:
    addon_usecolor = 'false'
try:
    label_color = control.setting('label.color')
except:
    label_color = 'none'
try:
    label_bold = control.setting('label.bold')
except:
    label_bold = 'false'
try:
    label_italic = control.setting('label.italic')
except:
    label_italic = 'false'
try:
    label_light = control.setting('label.light')
except:
    label_light = 'false'


def cleantext(text):
    text = text.replace('[B]','')
    text = text.replace('[/B]','')
    text = text.replace('[I]','')
    text = text.replace('[/I]','')   
    text = text.replace('[LIGHT]','')
    text = text.replace('[/LIGHT]','')
    return text


def customize_text(text):
    text = ensure_str(text)
    text = cleantext(text)
    if label_bold == 'true':
        text = '[B]' + text + '[/B]'
    if label_italic == 'true':
        text = '[I]' + text + '[/I]'
    if label_light == 'true':
        text = '[LIGHT]' + text + '[/LIGHT]'
    if addon_usecolor == 'true':
        text = '[COLOR ' + str(label_color) + ']' + text + '[/COLOR]'
    return text


def colorString(text, color=None):
    text = ensure_str(text)
    string = '[COLOR ' + str(color) + ']' + text + '[/COLOR]'
    return string


def colorChoice(setting, query=None):
    colorList = []
    for i in colorChart:
        colorList.append(colorString(i, i))
    color = control.selectDialog(colorList)
    if color == -1:
        return
    control.setSetting(setting, colorChart[color])
    if query:
        control.openSettings(query)


