# -*- coding: utf-8 -*-

import re

from six.moves.urllib_parse import urlparse, urlencode

from resources.lib.modules import client
from resources.lib.modules import directory as lets
from resources.lib.modules import log_utils


class nightride:
    def __init__(self):
        self.list = []
        self.stations_link = 'https://nightride.fm/stations'
        self.streamsafe_link = 'https://streamsafe.nightride.fm'


    def streamsafe(self):
        try:
            html = client.scrapePage(self.streamsafe_link).text
            items = client.parseDOM(html, 'a', ret='href', attrs={'class': 'preview'})
            for item in items:
                title = re.findall(r'/.+?/(.+?)$', item)[0]
                label = '[B]%s[/B]' % title
                item = '/' + item if not item.startswith('/') else item
                url =  self.streamsafe_link + item
                elements = urlparse(url)
                base = '%s://%s' % (elements.scheme, (elements.netloc or elements.path))
                url += '|%s' % urlencode({'Referer': base})
                self.list.append({'title': label, 'url': url, 'image': 'DefaultAudio.png', 'action': 'play'})
            lets.addDirectory(self.list)
            return self.list
        except:
            log_utils.log('streamsafe', 1)
            return self.list


    def stations(self):
        try:
            html = client.scrapePage(self.stations_link).text
            channels = re.findall(r'<a class="station" data-station=".+?" data-type="stream" href="(.+?)" title=".+?"><h3>(.+?)</h3><h4>(.+?)</h4></a>', html)
            for href, title, type in channels:
                label = '[B]%s[/B][CR][I]%s[/I]' % (title, type)
                station = re.findall(r'\?station=(.+?)$', href)[0]
                url = 'https://stream.nightride.fm/%s.m4a' % station
                elements = urlparse(url)
                base = '%s://%s' % (elements.scheme, (elements.netloc or elements.path))
                url += '|%s' % urlencode({'Referer': base})
                self.list.append({'title': label, 'url': url, 'image': 'DefaultAudio.png', 'action': 'play'})
            lets.addDirectory(self.list)
            return self.list
        except:
            log_utils.log('stations', 1)
            return self.list


